#include <iostream>
#include <string>
#include <math.h>
#include "eval.h"
#include "defs.h"
#include "pawntab.h"
#include "squares.h"
#include "bits.h"
#include "log.h"

//#define SPEAK

cEval::cEval()
{
	;
}

int cEval::doubledopen = 24;
int cEval::doubledend = 32;
int cEval::isolatedopen = 32;
int cEval::isolatedend = 48;
int cEval::openfileopen = 32;
int cEval::openfileend = 16;
int cEval::passeropen = 16;
int cEval::passerend = 64;

/*

*/
int cEval::bishopmobmin = -128;
int cEval::bishopmobmax = 128;
int cEval::knightmobmin = -32;
int cEval::knightmobmax = 32;
int cEval::rookmobmin = -32;
int cEval::rookmobmax = 32;
int cEval::queenmobmin = -32;
int cEval::queenmobmax = 32;


int cEval::bishopmob[14] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0};
int cEval::knightmob[8] = {0,0,0,0,0,0,0,0};
int cEval::queenmob[28] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
int cEval::rookmob[14] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0};

int cEval::pin = 48;

int cEval::trR = 256;
int cEval::trP = 128;
int cEval::trB = 256;

int cEval::minordev = 32;
int cEval::majorsoon = 32;

int cEval::rookopenfile = 8;
int cEval::rooksemiopenfile = 16;
int cEval::rookseventhrank = 48;
int cEval::queenseventhrank = 32;


void cEval::init_opt()
{
   opt->psqt = true;
   opt->pawns = true;
   opt->bishops = true;
   opt->rooks = true;
   opt->queens = true;
   opt->knights = true;
   opt->blocked = true;
   opt->development = true;
   opt->balance = true;
}

/*

All to get a curve rather than a stright line....

y = sqrt(r^2-(x-h)^2)

where r = max num squares reachable, x = squares reached, h = horiz center (always x)
*/
/*
void cEval::init_mobility()
{
    uint i;
    uint r;
    uint x;
    double value;
    uint spread;

    //bishop
    r = 14;
    spread = bishopmobmax-bishopmobmin;
    spread /= r;
#ifdef DEBUG
    cout<<"\n Bishop Mob ";
#endif
    for(x = 1; x <= r; ++x)
    {
        value = sqrt( (r * r) - (x * x) );
        value *= spread;
        value += bishopmobmin;
        bishopmob[r-x] = (int)value;
#ifdef DEBUG
        cout<<","<<bishopmob[r-x];
#endif
    }

    //rook
    r = 14;
    spread = rookmobmax-rookmobmin;
    spread /= r;
#ifdef DEBUG
    cout<<"\n Rook Mob ";
#endif
    for(x = 1; x <= r; ++x)
    {
        value = sqrt( (r * r) - (x * x) );
        value *= spread;
        value += rookmobmin;
        rookmob[r-x] = (int)value;
#ifdef DEBUG
        cout<<","<<rookmob[r-x];
#endif
    }

    //knight
    r = 8;
    spread = knightmobmax-knightmobmin;
    spread /= r;

#ifdef DEBUG
    cout<<"\n Knight Mob ";
#endif
    for(x = 1; x <= r; ++x)
    {
        value = sqrt( (r * r) - (x * x) );
        value *= spread;
        value += knightmobmin;
        knightmob[r-x] = (int)value;
#ifdef DEBUG
        cout<<","<<knightmob[r-x];
#endif
    }

    //queen
    r = 28;
    spread = queenmobmax-queenmobmin;
    spread /= r;

#ifdef DEBUG
    cout<<"\n Queen Mob ";
#endif
    for(x = 1; x <= r; ++x)
    {
        value = sqrt( (r * r) - (x * x) );
        value *= spread;
        value += queenmobmin;
        queenmob[r-x] = (int)value;
#ifdef DEBUG
        cout<<","<<queenmob[r-x];
#endif
    }

#ifdef DEBUG
cout<<endl;
#endif
}
*/

void cEval::init_mobility()
{
    uint r;
    uint x;
    int value;

    int start;
    int step;

    //bishop
    start = bishopmobmin;
    step = bishopmobmax;
    r = 14;
#ifdef DEBUG
    cout<<"\n Bishop Mob ";
#endif
    for(x = 0; x < r; ++x)
    {
        value = start + x*step;
     /*   cout<<"\n start "<<start;
        cout<<" x "<<x<<" step "<<step<<" value "<<value;*/
        bishopmob[x] = value;
#ifdef DEBUG
        cout<<","<<bishopmob[x];
#endif
    }

    start = rookmobmin;
    step = rookmobmax;
    r = 14;
#ifdef DEBUG
    cout<<"\n Rook Mob ";
#endif
    for(x = 0; x < r; ++x)
    {
        value = start + x*step;
        rookmob[x] = value;
#ifdef DEBUG
        cout<<","<<rookmob[x];
#endif
    }

    //knight
    start = knightmobmin;
    step = knightmobmax;
    r = 8;
#ifdef DEBUG
    cout<<"\n Knight Mob ";
#endif
    for(x = 0; x < r; ++x)
    {
        value = start + x*step;
        knightmob[x] = value;
#ifdef DEBUG
        cout<<","<<knightmob[x];
#endif
    }

    //queen
    start = queenmobmin;
    step = queenmobmax;
    r = 28;
#ifdef DEBUG
    cout<<"\n Queen Mob ";
#endif
    for(x = 0; x < r; ++x)
    {
        value = start + x*step;
        queenmob[x] = value;
#ifdef DEBUG
        cout<<","<<queenmob[x];
#endif
    }

#ifdef DEBUG
cout<<endl;
#endif
}

void cEval::reset_all_arrays()
{
    uint i;
	i=cW;
	pawnfiles[i]=0;
	pawns[i][OPE]=score[i][OPE]=mob[i][OPE]=dev[i][OPE]=blo[i][OPE]=pos[i][OPE]=bal[i][OPE]=0;
	pawns[i][END]=score[i][END]=mob[i][END]=dev[i][END]=blo[i][END]=pos[i][END]=bal[i][END]=0;

	i=cB;
    pawnfiles[i]=0;
	pawns[i][OPE]=score[i][OPE]=mob[i][OPE]=dev[i][OPE]=blo[i][OPE]=pos[i][OPE]=bal[i][OPE]=0;
	pawns[i][END]=score[i][END]=mob[i][END]=dev[i][END]=blo[i][END]=pos[i][END]=bal[i][END]=0;

    drawflag = false;
}

int cEval::lazyeval(cBoard &brd, cMaterial &mat)
{
    int material = mat.getmaterial(cW)-mat.getmaterial(cB);
    int enpsq = mat.getpsqvalend();
    int begpsq = mat.getpsqvalope();
	int phase = 24-((mat.getpcenum(pwQ) + mat.getpcenum(pbQ) )*4 +
       (mat.getpcenum(pwR) + mat.getpcenum(pbR))*2 +
       (mat.getpcenum(pwB) + mat.getpcenum(pbB)) + (mat.getpcenum(pwP) + mat.getpcenum(pbP)) );

    if(phase<0) phase = 0;

    int sbeg = material + begpsq;
    int send = material + enpsq;

    phase = (phase * 256 + (24 / 2)) / 24;
    int s = ((sbeg * (256 - phase)) + (send * phase)) / 256;

	return (brd.getside()==cW) ? s : -s;
}

int cEval::eval(cBoard &brd, cMaterial &mat, cPawntable &pawntab)
{
    reset_all_arrays();
    if(opt->balance)
    {
        balance(brd,mat);
        if(drawflag)
        {
            return 0;
        }
    }
    if(opt->pawns)
    score_pawn(brd, mat, pawntab);
	if(opt->rooks)
	score_rooks(brd, mat);
	if(opt->queens)
	score_queens(brd, mat);
	if(opt->blocked)
	score_blocked(brd);
	if(opt->development)
	score_development(brd);

    int material = mat.getmaterial(cW)-mat.getmaterial(cB);
    int opsqt=0;
    int epsqt=0;
    if(opt->psqt)
    {
        epsqt = mat.getpsqvalend();
        opsqt = mat.getpsqvalope();
    }

    int send = score[cW][END] -  score[cB][END]+
		       pawns[cW][END] -  pawns[cB][END]+
			   mob[cW][END]   -  mob[cB][END]+
			   dev[cW][END]   -  dev[cB][END]+
			   blo[cW][END]   -  blo[cB][END]+
			   pos[cW][END]   -  pos[cB][END]+
			   material + epsqt;
    int sbeg = score[cW][OPE] -  score[cB][OPE]+
			   pawns[cW][OPE] -  pawns[cB][OPE]+
			   mob[cW][OPE]   -  mob[cB][OPE]+
			   dev[cW][OPE]   -  dev[cB][OPE]+
			   blo[cW][OPE]   -  blo[cB][OPE]+
			   pos[cW][OPE]   -  pos[cB][OPE]+
			   material + opsqt;


	int phase = 24-((mat.getpcenum(pwQ) + mat.getpcenum(pbQ) )*4 +
       (mat.getpcenum(pwR) + mat.getpcenum(pbR))*2 +
       (mat.getpcenum(pwB) + mat.getpcenum(pbB)) + (mat.getpcenum(pwP) + mat.getpcenum(pbP)) );
  if(phase<0) phase = 0;


  phase = (phase * 256 + (24 / 2)) / 24;
  int s = ((sbeg * (256 - phase)) + (send * phase)) / 256;



#ifdef SPEAK
	cout<<"\n phase = "<<phase;
	cout<<"\n sbeg = "<<sbeg;
	cout<<" send = "<<send;
	cout<<" score = "<<s;
	cout<<"\n psq[OPE] = "<<mat.getpsqvalope();
	cout<<"\n psq[END] = "<<mat.getpsqvalend();

	cout<<"\n score[cW][OPE] = "<<score[cW][OPE]<<" score[cB][OPE] = "<<score[cB][OPE];
	cout<<"\n score[cW][END] = "<<score[cW][END]<<" score[cB][END] = "<<score[cB][END];

	cout<<"\n pawns[cW][OPE] = "<<pawns[cW][OPE]<<" pawns[cB][OPE] = "<<pawns[cB][OPE];
	cout<<"\n pawns[cW][END] = "<<pawns[cW][END]<<" pawns[cB][END] = "<<pawns[cB][END];

	cout<<"\n mob[cW][OPE] = "<<mob[cW][OPE]<<" mob[cB][OPE] = "<<mob[cB][OPE];
	cout<<"\n mob[cW][END] = "<<mob[cW][END]<<" mob[cB][END] = "<<mob[cB][END];

	cout<<"\n dev[cW][OPE] = "<<dev[cW][OPE]<<" dev[cB][OPE] = "<<dev[cB][OPE];
	cout<<"\n dev[cW][END] = "<<dev[cW][END]<<" dev[cB][END] = "<<dev[cB][END];

	cout<<"\n blo[cW][OPE] = "<<blo[cW][OPE]<<" blo[cB][OPE] = "<<blo[cB][OPE];
	cout<<"\n blo[cW][END] = "<<blo[cW][END]<<" blo[cB][END] = "<<blo[cB][END];

	cout<<"\n pos[cW][OPE] = "<<pos[cW][OPE]<<" pos[cB][OPE] = "<<pos[cB][OPE];
	cout<<"\n pos[cW][END] = "<<pos[cW][END]<<" pos[cB][END] = "<<pos[cB][END];

	cout<<"\n material "<<material;
	cout<<" (white = "<<mat.getmaterial(cW)<<") (black = "<<mat.getmaterial(cB)<<")";
	cout<<"\n \n FINAL SCORE:: ";
#endif

	return (brd.getside()==cW) ? s : -s;
}

void cEval::logeval(cBoard &brd, cMaterial &mat, cPawntable &pawntab)
{
    if(!logger.islog()) return;

    int material = mat.getmaterial(cW)-mat.getmaterial(cB);

     int phase = 24-((mat.getpcenum(pwQ) + mat.getpcenum(pbQ) )*4 +
       (mat.getpcenum(pwR) + mat.getpcenum(pbR))*2 +
       (mat.getpcenum(pwB) + mat.getpcenum(pbB)) + (mat.getpcenum(pwP) + mat.getpcenum(pbP)) );
     if(phase<0) phase = 0;
     phase = (phase * 256 + (24 / 2)) / 24;

    logger.file<<"static eval ("<<eval(brd,mat,pawntab)<<")";
    logger.file<<"lazy eval ("<<lazyeval(brd,mat)<<")\n";
    logger.file<<"positional score ("<<eval(brd,mat,pawntab)-mat.getmaterial(cW)-mat.getmaterial(cB)<<")\n";

    if(drawflag) {logger.file<<"material drawflag set, returned score 0\n"; return;}
    logger.file<<" phase = "<<phase;
	logger.file<<"\n psq[OPE] = "<<mat.getpsqvalope();
	logger.file<<"\n psq[END] = "<<mat.getpsqvalend();

	logger.file<<"\n score[cW][OPE] = "<<score[cW][OPE]<<" score[cB][OPE] = "<<score[cB][OPE];
	logger.file<<"\n score[cW][END] = "<<score[cW][END]<<" score[cB][END] = "<<score[cB][END];

	logger.file<<"\n pawns[cW][OPE] = "<<pawns[cW][OPE]<<" pawns[cB][OPE] = "<<pawns[cB][OPE];
	logger.file<<"\n pawns[cW][END] = "<<pawns[cW][END]<<" pawns[cB][END] = "<<pawns[cB][END];

	logger.file<<"\n mob[cW][OPE] = "<<mob[cW][OPE]<<" mob[cB][OPE] = "<<mob[cB][OPE];
	logger.file<<"\n mob[cW][END] = "<<mob[cW][END]<<" mob[cB][END] = "<<mob[cB][END];

	logger.file<<"\n dev[cW][OPE] = "<<dev[cW][OPE]<<" dev[cB][OPE] = "<<dev[cB][OPE];
	logger.file<<"\n dev[cW][END] = "<<dev[cW][END]<<" dev[cB][END] = "<<dev[cB][END];

	logger.file<<"\n blo[cW][OPE] = "<<blo[cW][OPE]<<" blo[cB][OPE] = "<<blo[cB][OPE];
	logger.file<<"\n blo[cW][END] = "<<blo[cW][END]<<" blo[cB][END] = "<<blo[cB][END];

	logger.file<<"\n pos[cW][OPE] = "<<pos[cW][OPE]<<" pos[cB][OPE] = "<<pos[cB][OPE];
	logger.file<<"\n pos[cW][END] = "<<pos[cW][END]<<" pos[cB][END] = "<<pos[cB][END];

	logger.file<<"\n material "<<material;
	logger.file<<" (white = "<<mat.getmaterial(cW)<<") (black = "<<mat.getmaterial(cB)<<")\n";

	logger.file.flush();
}


void cEval::score_development(cBoard &brd)
{
    int soon = 0;
    uint *board = brd.p2board();
    if(board[C1] == pwB) { dev[cW][OPE] -= minordev; soon++; }
    if(board[F1] == pwB) { dev[cW][OPE] -= minordev; soon++; }
    if(board[G1] == pwN) { dev[cW][OPE] -= minordev; soon++; }
    if(board[B1] == pwN) { dev[cW][OPE] -= minordev; soon++; }

    //now penalty for queen moving too soon
    if(board[D1] != pwQ)  dev[cW][OPE] -= majorsoon*soon;

    soon=0;
    if(board[C8] == pbB) { dev[cB][OPE] -= minordev; soon++; }
    if(board[F8] == pbB) { dev[cB][OPE] -= minordev; soon++; }
    if(board[G8] == pbN) { dev[cB][OPE] -= minordev; soon++; }
    if(board[B8] == pbN) { dev[cB][OPE] -= minordev; soon++; }

    //now penalty for queen moving too soon
    if(board[D8] != pbQ)  dev[cB][OPE]-= majorsoon*soon;
}

void cEval::score_blocked(cBoard &brd)
{
    uint *board = brd.p2board();
	//trapped Bishop
	if(board[A7]==pwB && board[B6]==pbP) { blo[cW][OPE] -= trB; }
	if(board[H7]==pwB && board[G6]==pbP) { blo[cW][OPE] -= trB;  }
	if(board[A6]==pwB && board[B5]==pbP) { blo[cW][OPE] -= trB; }
	if(board[H6]==pwB && board[G5]==pbP) { blo[cW][OPE] -= trB;  }
	if(board[A2]==pbB && board[B3]==pwP) { blo[cB][OPE] -= trB;   }
	if(board[H2]==pbB && board[G3]==pwP) { blo[cB][OPE] -= trB;   }
	if(board[A3]==pbB && board[B4]==pwP) { blo[cB][OPE] -= trB; }
	if(board[H3]==pbB && board[G4]==pwP) { blo[cB][OPE] -= trB; }

	if((board[C1] == pwK || board[B1] == pwK) && (board[A1] == pwR || board[B1] == pwR)) { blo[cW][OPE] -= trR; }
    if((board[F1] == pwK || board[G1] == pwK) && (board[H1] == pwR || board[G1] == pwR)) { blo[cW][OPE] -= trR; }
    if((board[C8] == pbK || board[B8] == pbK) && (board[A8] == pbR || board[B8] == pbR)) { blo[cB][OPE] -= trR; }
    if((board[F8] == pbK || board[G8] == pbK) && (board[H8] == pbR || board[G8] == pbR)) { blo[cB][OPE] -= trR; }


	//minors blocking centre pawns...
	if(board[D2]==pwP && (board[D3]==pwB || board[D3]==pwN)) blo[cW][OPE] -= trP;
	if(board[E2]==pwP && (board[E3]==pwB || board[E3]==pwN)) blo[cW][OPE] -= trP;
	if(board[D7]==pbP && (board[D6]==pbB || board[D6]==pbN)) blo[cB][OPE] -= trP;
	if(board[E7]==pbP && (board[E6]==pbB || board[E6]==pbN)) blo[cB][OPE] -= trP;
}
